#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(t--) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

int n;
int matrix[100][100];

int dsu[100];

int findSet(int v) {
	if (dsu[v] == v)
		return v;
	return dsu[v] = findSet(dsu[v]);
}

void merge(int q, int w) {
	q = findSet(q);
	w = findSet(w);
	if (rand() & 1)
		dsu[q] = w;
	else
		dsu[w] = q;
}

vector<pair<int, pi>> edges;

void solve() {
	cin >> n;
	for (int i = 0; i < n; ++i)
		for (int j = 0; j < n; ++j) {
			cin >> matrix[i][j];
			edges.push_back(mp(matrix[i][j], mp(i, j)));
		}

	sort(all(edges));
	reverse(all(edges));

	vector<pair<pi, int>> res;
	int sum = 0;
	for (int i = 0; i < n; ++i)
		dsu[i] = i;

	vector<vector<pair<int, int>>> g(n);

	for (int i = 0; i < edges.size(); ++i) {
		int a = edges[i].second.first;
		int b = edges[i].second.second;
		if (findSet(a) != findSet(b)) {
			merge(a, b);
			res.push_back(mp(mp(a, b), edges[i].first));
			sum += edges[i].first;
			g[a].push_back(mp(b, edges[i].first));
			g[b].push_back(mp(a, edges[i].first));
		}
	}

	for (int i = 0; i < n; ++i) {
		vector<int> d(n, 0);
		d[i] = 1e9;
		queue<int> q;
		q.push(i);
		while(!q.empty()) {
			int v = q.front();
			q.pop();
			for (int i = 0; i < g[v].size(); ++i) {
				int to = g[v][i].first;
				if (d[to] == 0) {
					d[to] = min(d[v], g[v][i].second);
					q.push(to);
				}
			}
		}

		for (int j = 0; j < n; ++j)
			if (i != j && d[j] != matrix[i][j]) {
				cout << "NO\n";
				return;
			}
	}

	cout << "YES\n";
	cout << res.size() << "\n";
	for (int i = 0; i < res.size(); ++i)
		cout << res[i].first.first + 1 << ' ' << res[i].first.second + 1 << ' ' << res[i].second << "\n";
}